/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export.csv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class CsvFormatter {
    private final DecimalFormat numberFormat;
    private final DecimalFormat bigNumberFormat;
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter timeFormatter;
    private final DateTimeFormatter datetimeFormatter;
    private final NumberFormat percentFormat;
    private final String dateFormatStr;
    private final String timeFormatStr;
    private final String datetimeFormatStr;
    private final boolean zeroDateAsNull;
    private final String nullDateStr;
    private final String nullDatetimeStr;
    private static final Pattern DT_SPACE_REDUCTION = Pattern.compile("([.])\\s+");

    public CsvFormatter(char decimalSeparator, String thousandsSeparator, int fractionalDigits, String dateFormat, String timeFormat, String datetimeFormat, boolean useUnicodeSymbols, boolean zeroDateAsNull) {
        boolean thousandsSeparated = !Strings.isNullOrEmpty(thousandsSeparator);
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setDecimalSeparator(decimalSeparator);
        if (thousandsSeparated) {
            symbols.setGroupingSeparator(thousandsSeparator.charAt(0));
        }
        if (!useUnicodeSymbols) {
            symbols.setInfinity("Inf");
            symbols.setNaN("NaN");
        }
        int maxFd = fractionalDigits < 0 ? Integer.MAX_VALUE : fractionalDigits;
        this.numberFormat = new DecimalFormat();
        this.numberFormat.setDecimalFormatSymbols(symbols);
        this.numberFormat.setMaximumFractionDigits(maxFd);
        this.numberFormat.setGroupingUsed(thousandsSeparated);
        this.bigNumberFormat = new DecimalFormat();
        this.bigNumberFormat.setDecimalFormatSymbols(symbols);
        this.bigNumberFormat.setMaximumFractionDigits(maxFd);
        this.bigNumberFormat.setGroupingUsed(thousandsSeparated);
        this.bigNumberFormat.setParseBigDecimal(true);
        this.percentFormat = new DecimalFormat("#.# '%'", symbols);
        this.percentFormat.setMaximumFractionDigits(maxFd);
        this.percentFormat.setMinimumFractionDigits(1);
        this.dateFormatStr = dateFormat;
        this.dateFormatter = CsvFormatter.createFormatter(dateFormat);
        this.timeFormatStr = timeFormat;
        this.timeFormatter = CsvFormatter.createFormatter(timeFormat);
        this.datetimeFormatStr = datetimeFormat;
        this.datetimeFormatter = CsvFormatter.createFormatter(datetimeFormat);
        if (zeroDateAsNull) {
            this.nullDateStr = this.dateFormatStr.replaceAll("\\w", "0");
            this.nullDatetimeStr = this.datetimeFormatStr.replaceAll("\\w", "0");
        } else {
            this.nullDateStr = null;
            this.nullDatetimeStr = null;
        }
        this.zeroDateAsNull = zeroDateAsNull;
    }

    private static DateTimeFormatter createFormatter(String sdfPattern) {
        DateTimeFormatterBuilder b = new DateTimeFormatterBuilder();
        b.parseLenient();
        b.appendPattern(CsvFormatter.toDtf(sdfPattern));
        return b.toFormatter();
    }

    @VisibleForTesting
    static String toDtf(String sdfPattern) {
        int n = sdfPattern.length();
        StringBuilder sb = new StringBuilder(n);
        boolean inSrcEsc = false;
        boolean inTgtEsc = false;
        for (int i = 0; i < n; ++i) {
            char ch = sdfPattern.charAt(i);
            if (ch == '\'') {
                if (i + 1 < n && sdfPattern.charAt(i + 1) == '\'') {
                    ++i;
                    sb.append("''");
                    continue;
                }
                inSrcEsc = !inSrcEsc;
                continue;
            }
            if (inSrcEsc) {
                if (!inTgtEsc) {
                    inTgtEsc = true;
                    sb.append('\'');
                }
            } else if (Character.isLetter(ch) == inTgtEsc) {
                inTgtEsc = !inTgtEsc;
                sb.append('\'');
            }
            sb.append(ch);
        }
        if (inTgtEsc) {
            sb.append('\'');
        }
        return sb.toString();
    }

    public String formatNumber(double value) {
        return this.numberFormat.format(value);
    }

    public String formatNumber(float value) {
        return this.numberFormat.format(value);
    }

    public String formatNumber(BigDecimal value) {
        return this.numberFormat.format(value);
    }

    public String formatPercent(double value) {
        return this.percentFormat.format(value * 100.0);
    }

    public String formatDate(LocalDate date) {
        return date.format(this.dateFormatter);
    }

    public String formatDatetime(LocalDateTime dt) {
        return dt.format(this.datetimeFormatter);
    }

    public String formatTime(LocalTime time) {
        return time.format(this.timeFormatter);
    }

    @Nonnull
    public Number parseNumber(String csvValue) throws ParseException {
        if (csvValue.isEmpty()) {
            throw new ParseException("Empty input string", 0);
        }
        ParsePosition pp = new ParsePosition(0);
        Number res = this.numberFormat.parse(csvValue, pp);
        if (pp.getIndex() == 0) {
            throw new ParseException("Invalid input \"" + csvValue + "\"", 0);
        }
        if (pp.getIndex() != csvValue.length()) {
            throw new ParseException("Cannot parse entire input string \"" + csvValue + "\"", pp.getIndex());
        }
        return res;
    }

    public BigDecimal parseBigDecimal(String csvValue) throws ParseException {
        if (csvValue.isEmpty()) {
            throw new ParseException("Empty input string", 0);
        }
        ParsePosition pp = new ParsePosition(0);
        BigDecimal res = (BigDecimal)this.bigNumberFormat.parse(csvValue, pp);
        if (pp.getIndex() == 0) {
            throw new ParseException("Invalid input \"" + csvValue + "\"", 0);
        }
        if (pp.getIndex() != csvValue.length()) {
            throw new ParseException("Cannot parse entire input string \"" + csvValue + "\"", pp.getIndex());
        }
        return res;
    }

    public DateParsingResult<LocalDate> parseDate(String csvValue) throws ParseException {
        if (this.zeroDateAsNull && csvValue.startsWith(this.nullDateStr)) {
            return new DateParsingResult<Object>(null, csvValue.length() == this.nullDateStr.length(), this.dateFormatStr);
        }
        return CsvFormatter.parse0(this.dateFormatter, this.dateFormatStr, csvValue, LocalDate::from);
    }

    public DateParsingResult<LocalTime> parseTime(String csvValue) throws ParseException {
        return CsvFormatter.parse0(this.timeFormatter, this.timeFormatStr, csvValue, LocalTime::from);
    }

    public DateParsingResult<LocalDateTime> parseDatetime(String csvValue) throws ParseException {
        if (this.zeroDateAsNull && csvValue.startsWith(this.nullDatetimeStr)) {
            return new DateParsingResult<Object>(null, csvValue.length() == this.nullDatetimeStr.length(), this.datetimeFormatStr);
        }
        return CsvFormatter.parse0(this.datetimeFormatter, this.datetimeFormatStr, csvValue, LocalDateTime::from);
    }

    private static <T extends Temporal> DateParsingResult<T> parse0(@Nonnull DateTimeFormatter formatter, String formatStr, @Nonnull String value, Function<TemporalAccessor, T> f) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        try {
            String val = DT_SPACE_REDUCTION.matcher(value).replaceAll("$1");
            TemporalAccessor ta = formatter.parse((CharSequence)val, pos);
            return new DateParsingResult<Temporal>((Temporal)f.apply(ta), pos.getIndex() >= value.length(), formatStr);
        }
        catch (IndexOutOfBoundsException | DateTimeParseException e) {
            throw new ParseException("Unparseable date \"" + value + "\" by format \"" + formatStr + "\"", pos.getErrorIndex());
        }
    }

    public Number parsePercent(String csvValue) throws ParseException {
        return this.percentFormat.parse(csvValue).doubleValue() / 100.0;
    }

    public static class DateParsingResult<T extends Temporal> {
        private final T temporal;
        private final boolean wholeTextParsed;
        private final String formatStr;

        private DateParsingResult(T temporal, boolean wholeTextParsed, String formatStr) {
            this.temporal = temporal;
            this.wholeTextParsed = wholeTextParsed;
            this.formatStr = formatStr;
        }

        public T getTemporal() {
            return this.temporal;
        }

        public boolean isWholeTextParsed() {
            return this.wholeTextParsed;
        }

        public String getFormatString() {
            return this.formatStr;
        }
    }
}

